import type { Metadata } from "next";
import { Geist, Geist_Mono } from "next/font/google";
import "./globals.css";
import Link from "next/link";
import ThemeToggle from "@/components/ThemeToggle";
import { AuthProvider } from "@/contexts/AuthContext";
import AuthButton from "@/components/AuthButton";

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
});

export const metadata: Metadata = {
  title: "EcoScope - Calculator Emisii Agricole",
  description: "Calculator profesional pentru emisiile de carbon în agricultură",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body
        className={`${geistSans.variable} ${geistMono.variable} antialiased bg-gradient-to-b from-white to-emerald-50 text-slate-900`}
      >
        <AuthProvider>
          <header className="border-b border-color surface-bg/80 backdrop-blur sticky top-0 z-40">
            <div className="mx-auto max-w-6xl px-6 py-4 flex items-center justify-between">
              <div className="flex items-center gap-2">
                <span className="inline-block h-8 w-8 rounded-full bg-emerald-600" />
                <span className="font-semibold text-emerald-800">EcoScope</span>
              </div>
              <nav className="flex items-center gap-6 text-sm">
                <Link href="/" className="hover:text-emerald-700">Acasă</Link>
                <Link href="/wizard" className="hover:text-emerald-700">Calculator</Link>
                <Link href="/my-reports" className="hover:text-emerald-700">Rapoartele mele</Link>
                <Link href="/metodologie" className="hover:text-emerald-700">Metodologie</Link>
                <Link href="/contact" className="hover:text-emerald-700">Contact</Link>
                <ThemeToggle />
                <AuthButton />
              </nav>
            </div>
          </header>
          {children}
          <footer className="mt-16 border-t border-color surface-bg">
            <div className="mx-auto max-w-6xl px-6 py-6 text-sm text-gray-600">
              <div className="flex items-center justify-between mb-4">
                <p>© {new Date().getFullYear()} EcoScope</p>
                <div className="flex items-center gap-6">
                  <Link href="/metodologie" className="hover:text-emerald-700 transition-colors">
                    Metodologie
                  </Link>
                  <Link href="/contact" className="hover:text-emerald-700 transition-colors">
                    Contact
                  </Link>
                </div>
              </div>
              <div className="flex items-center justify-between">
                <p>Calculator profesional pentru emisiile de carbon în agricultură</p>
                <div className="flex items-center gap-4">
                  <Link href="/metodologie#ghg-protocol" className="hover:text-emerald-700 transition-colors">
                    GHG Protocol
                  </Link>
                  <span>·</span>
                  <Link href="/metodologie#ipcc" className="hover:text-emerald-700 transition-colors">
                    IPCC
                  </Link>
                  <span>·</span>
                  <Link href="/metodologie#trasabilitate" className="hover:text-emerald-700 transition-colors">
                    Trasabilitate
                  </Link>
                </div>
              </div>
            </div>
          </footer>
        </AuthProvider>
      </body>
    </html>
  );
}
