import Link from "next/link";

export default function MetodologiePage() {
  return (
    <main className="mx-auto max-w-4xl p-6">
      <div className="mb-8">
        <Link href="/" className="inline-flex items-center text-emerald-700 hover:text-emerald-800 mb-4">
          <svg className="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M10 19l-7-7m0 0l7-7m-7 7h18" />
          </svg>
          Înapoi la pagina principală
        </Link>
        <h1 className="text-3xl font-bold text-emerald-800 mb-4">Metodologie de calcul</h1>
        <p className="text-lg text-gray-600">
          EcoScope utilizează standarde internaționale recunoscute pentru calculul emisiilor de gaze cu efect de seră în agricultură.
        </p>
      </div>

      <div className="space-y-8">
        {/* GHG Protocol */}
        <section id="ghg-protocol" className="bg-white rounded-lg border border-gray-200 p-6">
          <h2 className="text-2xl font-semibold text-emerald-800 mb-4 flex items-center">
            <span className="w-8 h-8 bg-emerald-100 rounded-full flex items-center justify-center mr-3">
              <span className="text-emerald-600 font-bold">1</span>
            </span>
            GHG Protocol
          </h2>
          <div className="prose max-w-none">
            <p className="text-gray-700 mb-4">
              Calculatorul nostru respectă <strong>GHG Protocol Corporate Standard</strong> și <strong>GHG Protocol Agricultural Guidance</strong> 
              pentru clasificarea și calculul emisiilor pe trei scope-uri:
            </p>
            <div className="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
              <div className="bg-red-50 border border-red-200 rounded-lg p-4">
                <h3 className="font-semibold text-red-800 mb-2">Scope 1 - Emisii directe</h3>
                <ul className="text-sm text-red-700 space-y-1">
                  <li>• Combustibili utilaje agricole</li>
                  <li>• N₂O din îngrășăminte</li>
                  <li>• CH₄ din fermentație</li>
                  <li>• Emisii din irigare</li>
                </ul>
              </div>
              <div className="bg-orange-50 border border-orange-200 rounded-lg p-4">
                <h3 className="font-semibold text-orange-800 mb-2">Scope 2 - Emisii indirecte</h3>
                <ul className="text-sm text-orange-700 space-y-1">
                  <li>• Electricitate cumpărată</li>
                  <li>• Încălzire</li>
                  <li>• Răcire</li>
                </ul>
              </div>
              <div className="bg-blue-50 border border-blue-200 rounded-lg p-4">
                <h3 className="font-semibold text-blue-800 mb-2">Scope 3 - Alte emisii indirecte</h3>
                <ul className="text-sm text-blue-700 space-y-1">
                  <li>• Transport inputuri</li>
                  <li>• Transport producție</li>
                  <li>• Procesare</li>
                  <li>• Deșeuri</li>
                </ul>
              </div>
            </div>
          </div>
        </section>

        {/* IPCC */}
        <section id="ipcc" className="bg-white rounded-lg border border-gray-200 p-6">
          <h2 className="text-2xl font-semibold text-emerald-800 mb-4 flex items-center">
            <span className="w-8 h-8 bg-emerald-100 rounded-full flex items-center justify-center mr-3">
              <span className="text-emerald-600 font-bold">2</span>
            </span>
            IPCC Guidelines
          </h2>
          <div className="prose max-w-none">
            <p className="text-gray-700 mb-4">
              Factorii de emisie sunt bazați pe <strong>IPCC 2019 Refinement</strong> și <strong>IPCC 2006 Guidelines</strong> 
              pentru inventarierea națională a gazelor cu efect de seră.
            </p>
            <div className="bg-gray-50 rounded-lg p-4 mb-4">
              <h3 className="font-semibold text-gray-800 mb-2">Factori de emisie utilizați:</h3>
              <div className="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                <div>
                  <p><strong>Electricitate:</strong> 0.27 kg CO₂e/kWh (media UE)</p>
                  <p><strong>Motorină:</strong> 2.68 kg CO₂e/L</p>
                  <p><strong>Benzină:</strong> 2.31 kg CO₂e/L</p>
                </div>
                <div>
                  <p><strong>N₂O din N:</strong> 1.57 kg CO₂e/kg N</p>
                  <p><strong>Transport:</strong> 0.15 kg CO₂e/km</p>
                  <p><strong>Pesticide:</strong> 0.5 kg CO₂e/kg</p>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* Trasabilitate */}
        <section id="trasabilitate" className="bg-white rounded-lg border border-gray-200 p-6">
          <h2 className="text-2xl font-semibold text-emerald-800 mb-4 flex items-center">
            <span className="w-8 h-8 bg-emerald-100 rounded-full flex items-center justify-center mr-3">
              <span className="text-emerald-600 font-bold">3</span>
            </span>
            Trasabilitate și transparență
          </h2>
          <div className="prose max-w-none">
            <p className="text-gray-700 mb-4">
              Fiecare calcul este complet trasabil, cu surse documentate și ipoteze clare pentru toate valorile utilizate.
            </p>
            <div className="space-y-4">
              <div className="flex items-start">
                <svg className="w-5 h-5 text-emerald-600 mr-3 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <div>
                  <h3 className="font-semibold text-gray-800">Documentație completă</h3>
                  <p className="text-sm text-gray-600">Toate calculele sunt documentate cu formule, surse și ipoteze</p>
                </div>
              </div>
              <div className="flex items-start">
                <svg className="w-5 h-5 text-emerald-600 mr-3 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <div>
                  <h3 className="font-semibold text-gray-800">Factori editabili</h3>
                  <p className="text-sm text-gray-600">Utilizatorii pot ajusta factorii de emisie pentru condiții locale</p>
                </div>
              </div>
              <div className="flex items-start">
                <svg className="w-5 h-5 text-emerald-600 mr-3 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <div>
                  <h3 className="font-semibold text-gray-800">Rapoarte exportabile</h3>
                  <p className="text-sm text-gray-600">Rezultatele pot fi exportate în PDF pentru audit și verificare</p>
                </div>
              </div>
            </div>
          </div>
        </section>

        {/* Procesul de calcul */}
        <section className="bg-white rounded-lg border border-gray-200 p-6">
          <h2 className="text-2xl font-semibold text-emerald-800 mb-4 flex items-center">
            <span className="w-8 h-8 bg-emerald-100 rounded-full flex items-center justify-center mr-3">
              <span className="text-emerald-600 font-bold">4</span>
            </span>
            Procesul de calcul
          </h2>
          <div className="prose max-w-none">
            <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
              <div className="text-center">
                <div className="w-12 h-12 bg-emerald-100 rounded-full flex items-center justify-center mx-auto mb-3">
                  <span className="text-emerald-600 font-bold text-lg">1</span>
                </div>
                <h3 className="font-semibold text-gray-800 mb-2">Colectare date</h3>
                <p className="text-sm text-gray-600">Introducerea activităților și consumurilor anuale</p>
              </div>
              <div className="text-center">
                <div className="w-12 h-12 bg-emerald-100 rounded-full flex items-center justify-center mx-auto mb-3">
                  <span className="text-emerald-600 font-bold text-lg">2</span>
                </div>
                <h3 className="font-semibold text-gray-800 mb-2">Calcul emisii</h3>
                <p className="text-sm text-gray-600">Aplicarea factorilor de emisie pe fiecare activitate</p>
              </div>
              <div className="text-center">
                <div className="w-12 h-12 bg-emerald-100 rounded-full flex items-center justify-center mx-auto mb-3">
                  <span className="text-emerald-600 font-bold text-lg">3</span>
                </div>
                <h3 className="font-semibold text-gray-800 mb-2">Rezultate</h3>
                <p className="text-sm text-gray-600">Agregarea pe scope-uri și identificarea hotspot-urilor</p>
              </div>
            </div>
          </div>
        </section>

        {/* Surse și referințe */}
        <section className="bg-white rounded-lg border border-gray-200 p-6">
          <h2 className="text-2xl font-semibold text-emerald-800 mb-4">Surse și referințe</h2>
          <div className="prose max-w-none">
            <ul className="space-y-2 text-sm text-gray-700">
              <li>• <strong>GHG Protocol:</strong> Corporate Accounting and Reporting Standard (2004)</li>
              <li>• <strong>GHG Protocol:</strong> Agricultural Guidance (2014)</li>
              <li>• <strong>IPCC:</strong> 2019 Refinement to the 2006 IPCC Guidelines</li>
              <li>• <strong>IPCC:</strong> 2006 IPCC Guidelines for National Greenhouse Gas Inventories</li>
              <li>• <strong>European Environment Agency:</strong> EMEP/EEA air pollutant emission inventory guidebook</li>
              <li>• <strong>European Commission:</strong> EU Reference Scenario 2020</li>
            </ul>
          </div>
        </section>
      </div>
    </main>
  );
}
