"use client";
import { Bar } from "react-chartjs-2";
import {
  Chart as ChartJS,
  CategoryScale,
  LinearScale,
  BarElement,
  Title,
  Tooltip,
  Legend,
} from "chart.js";

ChartJS.register(CategoryScale, LinearScale, BarElement, Title, Tooltip, Legend);

export function BarChart({
  labels,
  baseline,
  project,
  title,
}: {
  labels: string[];
  baseline: number[];
  project: number[];
  title?: string;
}) {
  const data = {
    labels,
    datasets: [
      {
        label: "Baseline",
        data: baseline,
        backgroundColor: "rgba(107, 114, 128, 0.6)",
      },
      {
        label: "Proiect",
        data: project,
        backgroundColor: "rgba(16, 185, 129, 0.7)",
      },
    ],
  };

  const options = {
    responsive: true,
    plugins: {
      legend: { position: "top" as const },
      title: { display: !!title, text: title || "" },
    },
  };

  return <Bar options={options} data={data} />;
}


