import type { NextConfig } from "next";

const nextConfig: NextConfig = {
  // Enable standalone build for cPanel deployment
  output: 'standalone',
  
  // Optimize for production
  compress: true,
  
  // Disable x-powered-by header for security
  poweredByHeader: false,
  
  // Configure images for production
  images: {
    unoptimized: true, // For cPanel deployment
  },
  
  // Environment variables
  env: {
    CUSTOM_KEY: process.env.CUSTOM_KEY,
  },
  
  // Configure server external packages
  serverExternalPackages: ['@prisma/client'],
};

export default nextConfig;
