import Link from "next/link";

export default function Home() {
  return (
    <main>
      <section className="mx-auto max-w-6xl px-6 py-16 grid grid-cols-1 md:grid-cols-2 gap-8 items-center">
        <div>
          <h1 className="text-4xl md:text-5xl font-bold text-emerald-800">EcoScope – generarea rapidă a certificatelor de carbon</h1>
          <p className="mt-4 text-lg text-slate-700">Calculează amprenta, simulează scenarii și estimează veniturile din certificate – conform GHG Protocol și IPCC.</p>
          <div className="mt-6 flex gap-3">
            <Link className="rounded bg-emerald-600 px-5 py-3 text-white hover:bg-emerald-700 shadow" href="/wizard">Începe diagnosticul</Link>
            <a className="rounded border border-emerald-600 px-5 py-3 text-emerald-700 hover:bg-emerald-50 shadow" href="#features">Află mai mult</a>
          </div>
        </div>
        <div className="rounded-xl border border-color card p-6 shadow">
          <ul className="space-y-3 text-sm">
            <li className="flex items-start gap-3"><span className="mt-1 h-2 w-2 rounded-full bg-emerald-600"/> Scope 1: combustibili utilaje, N2O din îngrășăminte</li>
            <li className="flex items-start gap-3"><span className="mt-1 h-2 w-2 rounded-full bg-emerald-600"/> Scope 2: electricitate cumpărată</li>
            <li className="flex items-start gap-3"><span className="mt-1 h-2 w-2 rounded-full bg-emerald-600"/> Scenariu proiect: no‑till, cover crops, energie verde</li>
            <li className="flex items-start gap-3"><span className="mt-1 h-2 w-2 rounded-full bg-emerald-600"/> Estimare venit: Δ tCO2e × preț/t</li>
          </ul>
        </div>
      </section>

      <section id="features" className="mx-auto max-w-6xl px-6 py-12 grid grid-cols-1 md:grid-cols-3 gap-6">
        <div className="rounded-xl border border-color card p-6 shadow">
          <h3 className="font-semibold text-lg">Calculator trasabil</h3>
          <p className="mt-2 text-sm text-slate-600">Unități și factori de emisie editabili, surse IPCC/UE.</p>
        </div>
        <div className="rounded-xl border border-color card p-6 shadow">
          <h3 className="font-semibold text-lg">Scenarii „what‑if”</h3>
          <p className="mt-2 text-sm text-slate-600">Comparații Baseline vs Proiect pe categorii și scope.</p>
        </div>
        <div className="rounded-xl border bg-white p-6 shadow">
          <h3 className="font-semibold text-lg">Rezultate clare</h3>
          <p className="mt-2 text-sm text-slate-600">KPI, grafic „hotspots” și estimare venit din credite.</p>
        </div>
      </section>

      <section className="mx-auto max-w-6xl px-6 py-12 grid grid-cols-1 md:grid-cols-4 gap-6" id="metodologie">
        <div className="md:col-span-1">
          <h3 className="text-xl font-semibold">Pași rapizi</h3>
        </div>
        <div className="md:col-span-3 grid grid-cols-1 md:grid-cols-3 gap-6">
          <div className="rounded-lg bg-white p-5 border">
            <div className="text-emerald-700 font-semibold">1. Date de intrare</div>
            <p className="text-sm text-gray-600 mt-1">Suprafață, energie, combustibili, N, practici.</p>
          </div>
          <div className="rounded-lg bg-white p-5 border">
            <div className="text-emerald-700 font-semibold">2. Calcul</div>
            <p className="text-sm text-gray-600 mt-1">Emisii = activitate × factor; agregare pe scope.</p>
          </div>
          <div className="rounded-lg bg-white p-5 border">
            <div className="text-emerald-700 font-semibold">3. Rezultate</div>
            <p className="text-sm text-gray-600 mt-1">Δ tCO2e → certificate, potențial venit anual.</p>
          </div>
        </div>
      </section>
    </main>
  );
}
