"use client";
import { useFieldArray, useFormContext } from "react-hook-form";

export default function ParcelList() {
	const { control, register } = useFormContext();
	const { fields, append, remove } = useFieldArray({ name: "parcels", control });

	return (
		<div className="mt-8">
			<div className="flex items-center justify-between">
				<h3 className="text-lg font-semibold">Parcele</h3>
				<button type="button" onClick={() => append({ name: "Parcela nouă", areaHa: 0, tillage: "plough", fertilizerN_Kg: 0, coverCropsHa: 0 })} className="rounded bg-emerald-600 px-3 py-1.5 text-white text-sm hover:bg-emerald-700">Adaugă parcelă</button>
			</div>
			<div className="mt-4 space-y-4">
				{fields.map((f, idx) => (
					<div key={f.id} className="border border-color rounded-lg p-4">
					<div className="grid grid-cols-1 md:grid-cols-4 gap-3">
							<div>
								<label className="block text-sm">Nume parcelă</label>
								<input className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.name` as const)} />
							</div>
							<div>
								<label className="block text-sm">Suprafață (ha)</label>
								<input type="number" className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.areaHa` as const, { valueAsNumber: true })} />
							</div>
							<div>
								<label className="block text-sm">Lucrare sol</label>
								<select className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.tillage` as const)}>
									<option value="plough">Arat</option>
									<option value="min_till">Min-till</option>
									<option value="no_till">No-till</option>
								</select>
							</div>
						<div>
							<label className="block text-sm">Îngrășăminte N (kg)</label>
							<input type="number" className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.fertilizerN_Kg` as const, { valueAsNumber: true })} />
						</div>
						<div>
							<label className="block text-sm">Tip îngrășământ N</label>
							<input className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.fertilizerN_Type` as const)} />
						</div>
						<div>
							<label className="block text-sm">P2O5 (kg)</label>
							<input type="number" className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.fertilizerP2O5_Kg` as const, { valueAsNumber: true })} />
						</div>
						<div>
							<label className="block text-sm">Tip fosfați</label>
							<input className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.fertilizerP_Type` as const)} />
						</div>
						<div>
							<label className="block text-sm">K2O (kg)</label>
							<input type="number" className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.fertilizerK2O_Kg` as const, { valueAsNumber: true })} />
						</div>
						<div>
							<label className="block text-sm">Tip potasiu</label>
							<input className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.fertilizerK_Type` as const)} />
						</div>
					{/* Pesticide totalele nu sunt cerute explicit; colectăm tip, doză/ha, frecvență */}
						<div>
							<label className="block text-sm">Tip pesticid</label>
							<input className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.pesticideType` as const)} />
						</div>
						<div>
							<label className="block text-sm">Doză/ha (kg sau L)</label>
							<input type="number" className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.pesticideDosePerHa` as const, { valueAsNumber: true })} />
						</div>
						<div>
							<label className="block text-sm">Frecvență (aplicări/sezon)</label>
							<input type="number" className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.pesticideApplicationsPerSeason` as const, { valueAsNumber: true })} />
						</div>
						<div>
							<label className="block text-sm">Tip sămânță/material</label>
							<input className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.seedType` as const)} />
						</div>
						{/* Rata de semănat poate varia; o putem reintroduce dacă e cerută */}
							<div>
								<label className="block text-sm">Cover crops (ha)</label>
								<input type="number" className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.coverCropsHa` as const, { valueAsNumber: true })} />
							</div>
							<div>
								<label className="block text-sm">Irigare (m³)</label>
								<input type="number" className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.irrigationM3` as const, { valueAsNumber: true })} />
							</div>
						<div>
							<label className="block text-sm">Drenaj</label>
							<input type="checkbox" className="mt-2" {...register(`parcels.${idx}.drainage` as const)} />
						</div>
						<div>
							<label className="block text-sm">Agroforestry</label>
							<input type="checkbox" className="mt-2" {...register(`parcels.${idx}.agroforestry` as const)} />
						</div>
							<div>
								<label className="block text-sm">Tip sol</label>
								<input className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.soilType` as const)} />
							</div>
							<div>
								<label className="block text-sm">Utilizare precedentă</label>
								<input className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.previousUse` as const)} />
							</div>
						<div className="md:col-span-2">
							<label className="block text-sm">Eroziune / degradare (note)</label>
							<input className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.erosionDegradationNotes` as const)} />
						</div>
						<div className="md:col-span-2">
							<label className="block text-sm">Fertilitatea solului (analize/observații)</label>
							<input className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.soilFertilityNotes` as const)} />
						</div>
							<div>
								<label className="block text-sm">% import inputuri</label>
								<input type="number" className="mt-1 w-full rounded border p-2" {...register(`parcels.${idx}.importSharePct` as const, { valueAsNumber: true })} />
							</div>
					<div className="md:col-span-4 text-xs text-slate-500">
						Nota: colectăm exact câmpurile cerute la pct. 3 și 4, pe fiecare parcelă.
					</div>
						</div>
						<div className="mt-3 flex justify-end">
							<button type="button" onClick={() => remove(idx)} className="text-sm text-red-600 hover:underline">Șterge</button>
						</div>
					</div>
				))}
			</div>
		</div>
	);
}
