"use client";
import { useEffect, useState } from "react";

type Theme = "light" | "dark";

export default function ThemeToggle() {
  const [theme, setTheme] = useState<Theme>("light");

  useEffect(() => {
    const saved = (localStorage.getItem("econos-theme") as Theme) || "light";
    setTheme(saved);
    document.documentElement.setAttribute("data-theme", saved);
  }, []);

  const toggle = () => {
    const next: Theme = theme === "light" ? "dark" : "light";
    setTheme(next);
    document.documentElement.setAttribute("data-theme", next);
    localStorage.setItem("econos-theme", next);
  };

  return (
    <button
      onClick={toggle}
      aria-label="Schimbă tema"
      className="rounded border px-3 py-1.5 text-sm hover:bg-gray-50"
    >
      {theme === "light" ? "🌙 Dark" : "☀️ Light"}
    </button>
  );
}


